#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Distorted ringsMod01.fsh   by   flypig
//https://www.shadertoy.com/view/ll2Gzh
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
/*

Copyright (c) 2015 David Llewellyn-Jones

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define M_PI 3.1415926535897932384626433832795

// (((((x - xc1)**2) + ((y - yc1)**2) - (r1**2)) * (((x - xc2)**2) + ((y - yc2)**2) - (r2**2)))) < (s / 1000)


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 vTextureCoord = fragCoord / iResolution.xy;
    float width = iResolution.x;
    float height = iResolution.y;
    float time = iTime * 1000.0;

	vec2 ratio = vec2(width, height) / width;
	vec2 pos = vTextureCoord * ratio;
	float scale = (3.0 + sin(time / 25000.0)) / 5.0;
	pos += vec2(sin(time / 3500.0), sin(time / 3650.0)) * 0.1;
	vec2 centre = vec2(0.1 * scale, 0.1 * scale);

	float radius1 = distance(vec2(mod(sin(sin((0.5 * M_PI * pos.y) + time / 3800.0) + pos.x * M_PI), 0.2 * scale),
		mod(sin(cos((0.5 * M_PI * pos.x) + time / 4100.0) + pos.y * M_PI), 0.2 * scale)), centre);

	float angle1 = atan (pos.x - 0.5, pos.y - 0.5);

	float angle2 = atan (mod(sin(sin((0.5 * M_PI * pos.y) + time / 3800.0) + pos.x * M_PI), 0.2 * scale) - centre.x, 
		mod(sin(cos((0.5 * M_PI * pos.x) + time / 4100.0) + pos.y * M_PI), 0.2 * scale) - centre.y);

	float red = 0.0;
	float green = 0.0;
	float blue = 0.0;
	if ((radius1 < 0.09 * scale) && (radius1 > 0.06 * scale)) {
		red = 1.0 - (sin ((time / 3300.0) + angle2 * 3.0) + 1.0) / 3.0;
		green = (sin ((time / 3200.0) + angle2 * 3.0) + 1.0) / 2.0;
		blue = (sin ((time / 3200.0) + angle1 * 3.0) + 1.0) / 2.0;
	}
	else {
		red = 1.0;
		green = 1.0;
		blue = 0.5;

		vec2 shadow = vec2(+0.005, -0.005);
		float radius1 = distance(vec2(mod(sin(sin((0.5 * M_PI * (pos.y - shadow.y)) + time / 3800.0) + (pos.x - shadow.x) * M_PI), 0.2 * scale),
		mod(sin(cos((0.5 * M_PI * (pos.x - shadow.x)) + time / 4100.0) + (pos.y - shadow.y) * M_PI), 0.2 * scale)), centre);

		if ((radius1 < 0.09 * scale) && (radius1 > 0.06 * scale)) {
			float darkness = cos(M_PI * (((radius1 / scale) - 0.075) / 0.03));
			red = 1.0 - 0.5 * darkness;
			green = 1.0 - 0.5 * darkness;
			blue = 0.5 - 0.5 * darkness;
		}

	}

	vec4 colour = vec4(red, green, blue, 1.0);

	fragColor = colour;

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

